﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pcv/pcv.h>
#include <nn/os.h>

namespace nn {
namespace pcv {
namespace driver {
namespace detail {

void Initialize() NN_NOEXCEPT;
bool IsInitialized() NN_NOEXCEPT;
void Finalize() NN_NOEXCEPT;
Result SetPowerEnabled(nn::pcv::Module moduleId, bool enabled) NN_NOEXCEPT;
Result GetPossibleClockRates(nn::pcv::ClockRatesListType* pOutType,
                             nn::pcv::ClockHz* pOutRates,
                             int* pOutCount,
                             nn::pcv::Module moduleId,
                             int maxCount) NN_NOEXCEPT;
Result SetClockEnabled(nn::pcv::Module moduleId, bool enabled) NN_NOEXCEPT;
Result SetClockRate(nn::pcv::Module moduleId, nn::pcv::ClockHz clockRateHz) NN_NOEXCEPT;
Result GetClockRate(nn::pcv::ClockHz *pClockRateHz, nn::pcv::Module moduleId) NN_NOEXCEPT;
Result GetState(nn::pcv::ModuleState *pState, nn::pcv::Module moduleId) NN_NOEXCEPT;
Result SetMinVClockRate(nn::pcv::Module moduleId, nn::pcv::ClockHz clockRateHz) NN_NOEXCEPT;
Result SetReset(nn::pcv::Module moduleId, bool asserted) NN_NOEXCEPT;
Result SetVoltageEnabled(nn::pcv::PowerDomain powerDomain, bool enabled) NN_NOEXCEPT;
Result GetVoltageEnabled(bool* pEnabled, nn::pcv::PowerDomain powerDomain) NN_NOEXCEPT;
Result GetVoltageRange(nn::pcv::MicroVolt* pMinVolt, nn::pcv::MicroVolt* pMaxVolt, nn::pcv::MicroVolt* pStepVolt, nn::pcv::PowerDomain powerDomain) NN_NOEXCEPT;
Result SetVoltageValue(nn::pcv::PowerDomain powerDomain, nn::pcv::MicroVolt microVolt) NN_NOEXCEPT;
Result GetVoltageValue(nn::pcv::MicroVolt* pMicroVolt, nn::pcv::PowerDomain powerDomain) NN_NOEXCEPT;
Result GetTemperatureThresholds(nn::pcv::TemperatureThreshold* pThresholds, int* pOutCount, int maxCount) NN_NOEXCEPT;
Result SetTemperature(nn::pcv::MilliC temperatureMilliC) NN_NOEXCEPT;
Result SuspendClocks() NN_NOEXCEPT;
Result ResumeClocks() NN_NOEXCEPT;
Result SuspendVoltage() NN_NOEXCEPT;
Result ResumeVoltage() NN_NOEXCEPT;
nn::os::SystemEventType* GetPowerClockInfoEvent() NN_NOEXCEPT;
uint32_t GetOscillatorClock() NN_NOEXCEPT;
Result GetDvfsTable(uint32_t* pOutClocks, int32_t* pOutVoltages, int32_t* pOutCount, Module moduleId, int32_t maxCount) NN_NOEXCEPT;
void GetModuleStateTable(ModuleState* pOutModuleStates, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT;
void GetPowerDomainStateTable(PowerDomainState* pOutPowerDomainStates, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT;
void GetFuseInfo(uint32_t* pOutValues, int32_t* pOutCount, int32_t maxCount) NN_NOEXCEPT;
void GetDramId(uint32_t* pOutDramId) NN_NOEXCEPT;

} // namespace detail
} // namespace driver
} // namespace pcv
} // namespace nn
