﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/ipc/pctl_IpcSession.h>
#include <nn/pctl/detail/pctl_Log.h>

namespace nn { namespace pctl {

// アプリケーション起動時に呼び出されるpctl初期化関数
// (nninitInitializeSdkModule から呼び出し)
void Initialize() NN_NOEXCEPT
{
    auto result = detail::ipc::InitializeIpcSessionIfNeeded();
    if (result.IsSuccess())
    {
        // セッションが確立できた場合既にオブジェクトが生成されているはず
        NN_SDK_ASSERT_NOT_NULL(detail::ipc::GetService());
    }
    else
    {
        // セッションが張れなくてもこの段階では特に問題にしない
        // (実際に関数を利用しようとしたときにエラーとする)
        NN_DETAIL_PCTL_TRACE("[pctl] ipc session is not initialized: result = 0x%08lX\n", result.GetInnerValueForDebug());
    }
}

}}
