﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>

#include <cstdlib>

#if defined( NN_BUILD_CONFIG_TOOLCHAIN_GCC )
#define STRTOULL strtoull
#elif defined( NN_BUILD_CONFIG_OS_WIN )
#define STRTOULL _strtoui64
#else
#define STRTOULL std::strtoull
#endif

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

bool HandleIdString(uint64_t* outValue, const char* valueString, size_t valueLength) NN_NOEXCEPT
{
    if (valueLength > 16)
    {
        return false;
    }
    char tempBuffer[17];
    std::memcpy(tempBuffer, valueString, sizeof(char) * valueLength);
    tempBuffer[valueLength] = 0;
    char* ptr = nullptr;
    uint64_t val = STRTOULL(tempBuffer, &ptr, 16);
    if (ptr == nullptr || ptr == tempBuffer || *ptr != 0)
    {
        return false;
    }
    *outValue = val;
    return true;
}

int GetIndexFromString(const char* string, size_t stringLen, const StringValueDefinition* definitions, int count) NN_NOEXCEPT
{
    for (int i = 0; i < count; ++i)
    {
        auto& d = definitions[i];
        if (stringLen == d.length && std::strncmp(string, d.value, stringLen) == 0)
        {
            return i;
        }
    }
    return -1;
}

}}}}}
