﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/pctl_MiiDownloader.h>

#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/detail/pctl_Log.h>
#include <nn/pctl/detail/service/pctl_ServiceWatcher.h>
#include <nn/pctl/detail/service/watcher/dispatcher/pctl_MiiDownloadDispatcher.h>

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

nn::Result MiiDownloaderExecutor::Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT
{
    NN_RESULT_DO(
        dispatcher::MiiDownloadDispatcher::Execute(bufferInfo, m_pCancelable, m_OutputFileName, m_MiiUri, m_MiiContentType)
        );

    NN_RESULT_SUCCESS;
}

void MiiDownloaderExecutor::Cancel() NN_NOEXCEPT
{
    if (m_pCancelable != nullptr)
    {
        m_pCancelable->Cancel();
    }
}

}}}}}
