﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/pcm/pcm_ManagerImpl.h>
#include <nn/pcm/pcm_IManager.sfdl.h>
#include <nn/pcm/driver/pcm.h>

namespace nn { namespace pcm {

// マネージャーの実装
ManagerImpl::ManagerImpl() NN_NOEXCEPT
{
}

ManagerImpl::~ManagerImpl() NN_NOEXCEPT
{
}

nn::Result ManagerImpl::IsServiceEnabled(nn::sf::Out<bool> pOutIsServiceEnabled) NN_NOEXCEPT
{
    *pOutIsServiceEnabled = nn::pcm::driver::IsServiceEnabled();
    return nn::ResultSuccess();
}

nn::Result ManagerImpl::IsSupported(nn::sf::Out<bool> pOutIsSupported, std::int32_t point) NN_NOEXCEPT
{
    *pOutIsSupported = nn::pcm::driver::IsSupported(static_cast<nn::pcm::MeasuringPoint>(point));
    return nn::ResultSuccess();
}

nn::Result ManagerImpl::ReadCurrentPower(nn::sf::Out<int> pOutPower, std::int32_t point) NN_NOEXCEPT
{
    *pOutPower = nn::pcm::driver::ReadCurrentPower(static_cast<nn::pcm::MeasuringPoint>(point));
    return nn::ResultSuccess();
}

nn::Result ManagerImpl::ReadCurrentVoltage(nn::sf::Out<int> pOutVoltage, std::int32_t point) NN_NOEXCEPT
{
    *pOutVoltage = nn::pcm::driver::ReadCurrentVoltage(static_cast<nn::pcm::MeasuringPoint>(point));
    return nn::ResultSuccess();
}

}}
