﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/dd.h>

#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include "../detail/pcie_Memory.h"
#include "../detail/pcie_IManager.h"
#include "../detail/pcie_ISession.h"

namespace nn { namespace pcie { namespace server {

class ManagerImpl
    : public nn::sf::ISharedObject
{

public:

    NN_IMPLICIT ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;
    nn::Result RegisterClassDriver(nn::sf::Out<nn::sf::SharedPointer<nn::pcie::detail::ISession>> outSession,
                                   nn::sf::Out<nn::sf::NativeHandle> registrationEventHandle,
                                   ClassDriverConfig config,
                                   nn::sf::NativeHandle clientProcessHandle) NN_NOEXCEPT;
    nn::Result QueryFunctions(const nn::sf::OutBuffer& output,nn::sf::Out<int32_t> returnedCount) NN_NOEXCEPT;

private:
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    static void RegistrationCallback(uintptr_t classDriverContext) NN_NOEXCEPT;

    MyAllocator m_Allocator;
    std::aligned_storage<4 * 1024>::type m_HeapBuffer;
    nn::lmem::HeapHandle                 m_HeapHandle;

    class SessionImpl;
};


} // namespace server
} // namespace pci
} // namespace nn
