﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h>   // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>        // for nn::sf::ExpHeapStaticAllocator

#include "detail/pcie_Macros.h"
#include "detail/pcie_ServiceName.h"
#include "detail/pcie_ISession.h"
#include "detail/pcie_IManager.h"
#include "detail/pcie_ILoggedStateManager.h"

#include "pcie_CreateManager.h"

namespace nn { namespace pcie {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:
    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }
} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<nn::pcie::detail::IManager> CreateManagerByHipc() NN_NOEXCEPT
{
    Result result = ResultSuccess();
    // ServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IManager としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::pcie::detail::IManager> ret;
    result = nn::sf::CreateHipcProxyByName<nn::pcie::detail::IManager, MyAllocator::Policy>(&ret, nn::pcie::detail::ServiceName);
    NN_PCIE_ABORT_UPON_ERROR(result);
    return ret;
}

nn::sf::SharedPointer<nn::pcie::detail::ILoggedStateManager> CreateLoggedStateManagerByHipc() NN_NOEXCEPT
{
    Result result = ResultSuccess();
    // ServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IManager としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::pcie::detail::ILoggedStateManager> ret;
    result = nn::sf::CreateHipcProxyByName<nn::pcie::detail::ILoggedStateManager, MyAllocator::Policy>(&ret, nn::pcie::detail::LoggedStateServiceName);
    NN_PCIE_ABORT_UPON_ERROR(result);
    return ret;
}

}}
