﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/**
 * @file
 * @brief Internal driver types and definitions
 */

#pragma once

namespace nn { namespace pcie { namespace driver { namespace detail {



/**
 * @brief Address space of memory mapped resources, such as BARs
 */
typedef uint8_t   *ResourceAddr;


/**
 * @brief Size of memory mapped region
 */
typedef uint32_t  ResourceSize;

/**
 * @brief Reference to an Irq resource
 */
typedef int32_t IrqHandle;

// Used by platform specific root complex
enum IntVector
{
    IntVector_Wake,
    IntVector_Msi,
    IntVector_Int,
    IntVector_MaxTypes,
};

const int32_t MaxIntVectorCount = IntVector_MaxTypes;


} // namespace detail
} // namespace driver
} // namespace pcie
} // namespace nn

