﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief Device class
 *
 * @details Device is a container to hold one to many PCI
 *          functions.
 */

namespace nn { namespace pcie { namespace driver { namespace detail {

class Function;
class Bus;
class Driver;

class Device
{

public:
    Device(Driver *pDriver, DeviceNumber devNum, Bus *pBus);
    virtual ~Device();


    virtual Result Initialize();
    virtual Result Finalize();
    DeviceNumber GetDevNum();
    void AddFunction(Function &func);
    Result RemoveFunction(FunctionNumber funcNum);
    int32_t GetNumFunctions();
    Function* GetFunction(FunctionNumber funcNum);
    Bus* GetBus();
    bool GetResetUponResumeEnable();
    void SetResetUponResumeEnable(bool isResetUponResume);
    void * operator new(size_t size) NN_NOEXCEPT;
    void operator delete(void *p, size_t size) NN_NOEXCEPT;


    nn::util::IntrusiveListNode m_BusDevListNode;


protected:
    // Constructor initialized
    Driver          *m_pDriver;


private:
    typedef nn::util::IntrusiveList
    < Function,nn::util::IntrusiveListMemberNodeTraits<Function, &Function::m_DevFuncListNode>> FuncListType;

     // Constructor initialized
     DeviceNumber    m_DevNum;
     Bus            *m_pBus;
     int32_t         m_NumFunc;
     bool            m_IsResetUponResume;

     // List for managing list of functions associated with this device
     FuncListType    m_FuncList;
};

} // namespace detail
} // namespace driver
} // namespace pcie
} // namespace nn

