﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include "olsc_Downloader.h"

namespace nn { namespace olsc { namespace srv { namespace transfer {

MemoryDownloader::MemoryDownloader(CURL* curlHandle, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
    : CurlInputStreamBase(curlHandle, pCancelable)
{
}

// TODO : オーバーフロー検知
// *pDownloadSize == bufferSize の時、サーバーからの応答を取りきれてない可能性がある
Result MemoryDownloader::Download(size_t* pDownloadSize, void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(buffer != nullptr);
    NN_SDK_ASSERT(bufferSize > 0);

    // SetDebugMode();
    Open();
    NN_UTIL_SCOPE_EXIT
    {
        Close();
    };
    size_t downloadedBytes = 0;
    while (downloadedBytes < bufferSize)
    {
        auto size = Receive(reinterpret_cast<char*>(buffer) + downloadedBytes, bufferSize - downloadedBytes);
        if (size == 0)
        {
            break;
        }
        downloadedBytes += size;
    }
    NN_RESULT_DO(GetResult());
    *pDownloadSize = downloadedBytes;
    NN_RESULT_SUCCESS;
}

FsImporterDownloader::FsImporterDownloader(CURL* curlHandle, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
    : CurlInputStreamBase(curlHandle, pCancelable)
{
}

void FsImporterDownloader::SetInputBuffer(void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(buffer && bufferSize > 0u);
    m_Buffer = reinterpret_cast<char*>(buffer);
    m_BufferSize = bufferSize;
}

bool FsImporterDownloader::FillBuffer() NN_NOEXCEPT
{
    m_BufferedBytes = Receive(m_Buffer, m_BufferSize);
    return m_BufferedBytes > 0;
}

Result FsImporterDownloader::Download(fs::ISaveDataChunkImporter* importer) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Buffer != nullptr);
    NN_SDK_ASSERT(m_BufferSize > 0);

    // SetDebugMode();
    Open();
    NN_UTIL_SCOPE_EXIT
    {
        Close();
    };

    while(NN_STATIC_CONDITION(true))
    {
        if (!FillBuffer())
        {
            break;
        }

        NN_RESULT_DO(importer->Push(m_Buffer, m_BufferedBytes));
    }
    NN_RESULT_DO(GetResult());
    NN_RESULT_SUCCESS;
}

}}}} //namespace nn::olsc::srv::transfer

