﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include <nn/http/json/http_JsonPath.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>

#include "olsc_OutputStream.h"
#include "olsc_SaveDataArchiveInfoAdaptor.h"
#include "olsc_ComponentFileInfoAdaptor.h"

namespace nn { namespace olsc { namespace srv { namespace adaptor {

// TODO: 外からパースしたい Object 名を注入できるような Adaptor への統合

// ! 必ず GetResult の結果を確認してから出力値を信用する
class MixedInfoAdaptor
    : public AdaptorBase<8, 128>
{
public:
    NN_IMPLICIT MixedInfoAdaptor(
        SaveDataArchiveInfoOutputStreamBase* saveDataArchiveOutStream,
        ComponentFileInfoMemoryOutputStream* componentFileOutStream) NN_NOEXCEPT
        : m_SaveDataArchiveInfoAdaptor(saveDataArchiveOutStream)
        , m_ComponentFileInfoAdaptor(componentFileOutStream)
    {
    }
    virtual bool UpdateImpl(const JsonPathType& jsonPath, bool value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, uint64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;

    static const int MaxPathLength = 64;

    Result GetResult() const NN_NOEXCEPT;


private:
    SaveDataArchiveInfoAdaptor m_SaveDataArchiveInfoAdaptor;
    ComponentFileInfoAdaptor   m_ComponentFileInfoAdaptor;
    AdaptorBase<8, 128>* m_pAdaptorBase = nullptr;

    bool IsSaveDataArchiveInfoPath(const JsonPathType& jsonPath) const NN_NOEXCEPT;
    bool IsComponentFileInfoPath(const JsonPathType& jsonPath) const NN_NOEXCEPT;

};

}}}} // namespace nn::olsc::srv::adaptor
