﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "detail/olsc_Initialization.h"

#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/olsc_SystemEventHolder.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace olsc {

SystemEventHolder::SystemEventHolder() NN_NOEXCEPT : m_NativeHandleHolder(nullptr)
{
}

SystemEventHolder::SystemEventHolder(srv::INativeHandleHolder* nativeHandleHolder) NN_NOEXCEPT : m_NativeHandleHolder(nativeHandleHolder)
{
    NN_SDK_REQUIRES_NOT_NULL(nativeHandleHolder);

    sf::NativeHandle handle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_NativeHandleHolder->GetNativeHandle(&handle));
    handle.Detach();
}

SystemEventHolder::~SystemEventHolder() NN_NOEXCEPT
{
    if (m_NativeHandleHolder)
    {
        sf::ReleaseSharedObject(m_NativeHandleHolder);
    }
}

SystemEventHolder::SystemEventHolder(SystemEventHolder&& rhs) NN_NOEXCEPT : m_NativeHandleHolder(rhs.m_NativeHandleHolder)
{
    rhs.m_NativeHandleHolder = nullptr;
}

SystemEventHolder& SystemEventHolder::operator=(SystemEventHolder&& rhs) NN_NOEXCEPT
{
    SystemEventHolder s(std::move(rhs));
    swap(*this, s);
    return *this;
}

void SystemEventHolder::GetSystemEvent(os::SystemEvent* out) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_NativeHandleHolder);
    sf::NativeHandle handle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(m_NativeHandleHolder->GetNativeHandle(&handle));
    out->AttachReadableHandle(handle.GetOsHandle(), handle.IsManaged(), os::EventClearMode::EventClearMode_ManualClear);
    handle.Detach();
}

void swap(SystemEventHolder& lhs, SystemEventHolder& rhs) NN_NOEXCEPT
{
    std::swap(lhs.m_NativeHandleHolder, rhs.m_NativeHandleHolder);
}

}} // namespace nn::olsc

