﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/am/am_Shim.h>

namespace nn { namespace oe {

// シャットダウン要求を出す
NN_NORETURN Result RequestToShutdown() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetApplicationFunctions()->RequestToShutdown());
    for (;;)
    {
        os::SleepThread( TimeSpan::FromDays(1) );
    }
}

// 再起動要求を出す
NN_NORETURN Result RequestToReboot() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetApplicationFunctions()->RequestToReboot());
    for (;;)
    {
        os::SleepThread( TimeSpan::FromDays(1) );
    }
}

}}  // namespace nn::oe

