﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_StaticAssert.h>

#include <nn/oe/oe_DisplayResolutionApis.h>

#include <nn/am/am_Shim.h>

namespace nn { namespace oe {

//-----------------------------------------------------------------------------
// 画面解像度の取得
//
void GetDefaultDisplayResolution(int* pWidth, int* pHeight) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS( am::GetCommonStateGetter()->GetDefaultDisplayResolution( pWidth, pHeight ) );
}

//-----------------------------------------------------------------------------
// 画面解像度変更イベントの取得
//
void GetDefaultDisplayResolutionChangeEvent(os::SystemEvent* pEvent) NN_NOEXCEPT
{
    sf::NativeHandle nativeHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->GetDefaultDisplayResolutionChangeEvent(&nativeHandle));
    pEvent->AttachReadableHandle(nativeHandle.GetOsHandle(), nativeHandle.IsManaged(), os::EventClearMode_AutoClear);
    nativeHandle.Detach();
}

}}  // namespace nn::oe
