﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ntc/detail/service/core/ntc_ResponseParser.h>

namespace nn { namespace ntc { namespace detail { namespace service { namespace core {

namespace
{

#if defined(NN_BUILD_CONFIG_OS_WIN)
    inline int64_t StrToInt64(const char* str, char** endPtr, int radix) NN_NOEXCEPT
    {
        return _strtoi64(str, endPtr, radix);
    }
#else
    inline int64_t StrToInt64(const char* str, char** endPtr, int radix) NN_NOEXCEPT
    {
        return strtoll(str, endPtr, radix);
    }
#endif

}

//!< 時刻サーバーのレスポンス解析
nn::Result ParseTimeDataResponse(
    int64_t* pOutUnixTimeMilliSeconds, const char* pResponse, size_t responseSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutUnixTimeMilliSeconds);
    NN_SDK_ASSERT_NOT_NULL(pResponse);


    // ------------
    // ${unixtime}
    // ${global_ip}
    // ------------
    // のフォーマット. 改行は LF ('\n').
    //
    // unixtime : Unix時間をミリ秒単位で
    // global_ip : グローバルIP(Ipv4)
    //
    // 正しい値がサーバー側で扱えないような場合は,
    // unixtime, global_ip ともに 0 が入るので、受け入れ拒否する.

    // TORIAEZU:global_ip は無視.

    const size_t ResponseSizeMax = sizeof("9223372036854775807\n255.255.255.255");
    NN_RESULT_THROW_UNLESS(ResponseSizeMax >= responseSize, nn::time::ResultInvalidServerResponse());

    // NULL 終端チェック
    const auto len = nn::util::Strnlen(pResponse, static_cast<int>(responseSize));
    NN_RESULT_THROW_UNLESS(responseSize > static_cast<size_t>(len), nn::time::ResultInvalidServerResponse());

    char* stopPtr = nullptr;
    auto result = StrToInt64(pResponse, &stopPtr, 10);
    NN_RESULT_THROW_UNLESS(result != 0, nn::time::ResultInvalidServerResponse());
    NN_RESULT_THROW_UNLESS(*stopPtr == '\n', nn::time::ResultInvalidServerResponse());

    // NN_DETAIL_NTC_SERVER_LOG("pResponse:%s, time:%lld\n", pResponse, result);
    *pOutUnixTimeMilliSeconds = result;

    NN_RESULT_SUCCESS;
}

}}}}} // nn::ntc::detail::service::core
