﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ntc/detail/service/core/ntc_PmModuleManager.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ntc { namespace detail { namespace service { namespace core {

Result PmModuleManager::Initialize() NN_NOEXCEPT
{
    NN_RESULT_DO( m_PmModule.Initialize(
            nn::psc::PmModuleId_Ntc,
            nullptr,
            0,
            nn::os::EventClearMode_ManualClear) );

    NN_RESULT_SUCCESS;
}

Result PmModuleManager::HandlePmModule() NN_NOEXCEPT
{
    nn::psc::PmState    state;
    nn::psc::PmFlagSet  flags;

    NN_RESULT_DO( m_PmModule.GetRequest(&state, &flags) );

    switch(state)
    {
    case nn::psc::PmState_FullAwake:
        {
            this->FullAwakeCallback();
        }
        break;
    case nn::psc::PmState_MinimumAwake:
        {
            this->MinimumAwakeCallback();
        }
        break;
    case nn::psc::PmState_SleepReady:
        {
            this->SleepReadyCallback();
        }
        break;
    case nn::psc::PmState_ShutdownReady:
        {
            this->ShutdownReadyCallback();
        }
        break;
    default:
        break;
    }

    NN_RESULT_DO( m_PmModule.Acknowledge(state, nn::ResultSuccess()) );
    NN_RESULT_SUCCESS;
}

Result PmModuleManager::Finalize() NN_NOEXCEPT
{
    NN_RESULT_DO( m_PmModule.Finalize() );
    NN_RESULT_SUCCESS;
}

}}}}}

