﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_TaskType.h>
#include "ns_ApplicationInstallTask.h"
#include "ns_ApplicationApplyDeltaTask.h"

namespace nn { namespace ns { namespace srv {

    Result CleanupTask(ncm::ApplicationId id, IntegratedContentManager* integrated, RequestServer::ManagedStop&& stopper, TaskType taskType) NN_NOEXCEPT;
    Result CanCreateNetworkInstallTask(bool* outValue, ncm::ApplicationId id, ncm::ContentMetaType type, bool strictly = false) NN_NOEXCEPT;

    // スループット (byte/msec = kbyte/sec) を返す
    // 測定基準を満たしていない場合は、0 を返す
    int64_t CalculateThroughput(int64_t downloadSize, TimeSpan elapsedTime) NN_NOEXCEPT;

}}}

