﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentInfo.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace ns { namespace srv {
    inline ncm::ProgramId GetProgramId(ncm::ApplicationId id, uint8_t programIndex) NN_NOEXCEPT
    {
        ncm::ProgramId programId = { id.value + programIndex };
        return programId;
    }

    inline uint8_t GetProgramIndex(ncm::ApplicationId applicationId, ncm::ProgramId programId) NN_NOEXCEPT
    {
        auto diff = programId.value - applicationId.value;
        NN_ABORT_UNLESS(diff < UINT8_MAX);
        return static_cast<uint8_t>(diff);
    }

    inline ncm::ApplicationId GetApplicationId(ncm::ProgramId id, uint8_t programIndex) NN_NOEXCEPT
    {
        ncm::ApplicationId applicationId = { id.value - programIndex };
        return applicationId;
    }

    inline uint8_t GetProgramIndex(const ncm::ContentInfo& info) NN_NOEXCEPT
    {
        return info.GetIdOffset();
    }
}}}
