﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/detail/ns_Log.h>
#include <nn/ns/ns_Result.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace ns { namespace srv {

    // NPNS のステータスがオンライン(Connected) になっている時に実行するタスク
    class INpnsOnlineTask
    {
    public:
        enum Status {
            Skipped,
            NeedProcess,
            Finished,
        };

        NN_IMPLICIT INpnsOnlineTask(bool needsProcess) NN_NOEXCEPT
        {
            m_Status = needsProcess ? NeedProcess : Skipped;
        }
        virtual Result Process(nn::os::SystemEvent* cancelEvent) NN_NOEXCEPT = 0;

        Status GetStatus() const NN_NOEXCEPT
        {
            return m_Status;
        }

    protected:
        void UpdateStatus(Status status) NN_NOEXCEPT
        {
            m_Status = status;
        }

    private:
        Status m_Status;
    };

    Result ProcessWithNpnsOnlineApi(INpnsOnlineTask* tasks[], int taskCount, ManualClearSystemEvent* cancelEvent, uint32_t retryIntervalMin, uint32_t retryIntervalMax) NN_NOEXCEPT;
}}}
