﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentInfo.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ns { namespace srv {
    template <class T, class ListFuncT, class ExecFuncT>
    Result ForEachFunc(ListFuncT listFunc, ExecFuncT execFunc) NN_NOEXCEPT
    {
        constexpr int ListCount = 16;
        T list[ListCount];
        int count = 0;
        int offset = 0;
        do
        {
            NN_RESULT_DO(listFunc(&count, list, ListCount, offset));
            for (int i = 0; i < count; i++)
            {
                bool isEnd = false;
                NN_RESULT_DO(execFunc(&isEnd, list[i]));
                if (isEnd)
                {
                    NN_RESULT_SUCCESS;
                }
            }
            offset += count;
        } while (count == ListCount);

        NN_RESULT_SUCCESS;
    }

    template<class FuncT>
    Result ForEachContentInfo(const ncm::ContentMetaDatabase* db, const ncm::ContentMetaKey& key, FuncT func) NN_NOEXCEPT
    {
        auto listFunc = [&db, &key](int* outCount, ncm::ContentInfo* pList, int numList, int offset) NN_NOEXCEPT -> Result
        {
            return db->ListContentInfo(outCount, pList, numList, key, offset);
        };
        NN_RESULT_DO(ForEachFunc<ncm::ContentInfo>(listFunc, func));

        NN_RESULT_SUCCESS;
    }

    template<class FuncT>
    Result ForEachContentInfo(const IntegratedContentManager* integrated, const ncm::ContentMetaKey& key, FuncT func) NN_NOEXCEPT
    {
        auto listFunc = [&integrated, &key](int* outCount, ncm::ContentInfo* pList, int numList, int offset) NN_NOEXCEPT -> Result
        {
            return integrated->ListContentInfo(outCount, pList, numList, key, offset);
        };
        NN_RESULT_DO(ForEachFunc<ncm::ContentInfo>(listFunc, func));

        NN_RESULT_SUCCESS;
    }

}}}
