﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/srv/detail/json/ns_RapidJsonApi.h>
#include <nn/ns/srv/detail/json/ns_RapidJsonInputStream.h>
#include <nn/ns/srv/detail/json/ns_JsonAdaptor.h>
#include <nn/ns/srv/detail/json/ns_ResultForJson.h>

#include <nn/ns/srv/ns_DownloadTask.h>

namespace nn { namespace ns { namespace srv {

    typedef std::function<Result(DownloadTask*)> DownloadTaskCallback;

    class DownloadTaskListParser
    {
    public:
        template<typename InputStreamType>
        Result ParseTask(DownloadTask* downloadTaskBuffer, InputStreamType& inputStream, DownloadTaskCallback& callbackFunction) NN_NOEXCEPT;

        template<typename InputStreamType>
        Result Validate(InputStreamType& inputStream) NN_NOEXCEPT;
    };

}}}
