﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_Optional.h>
#include <nn/ncm/ncm_ContentMetaKey.h>

namespace nn { namespace ns { namespace srv {
    util::optional<ncm::ContentMetaKey> GetDebugSystemUpdateMeta() NN_NOEXCEPT;
    bool IsBgnupEnabled() NN_NOEXCEPT;
    TimeSpan GetBgnupRetrySpan() NN_NOEXCEPT;
    bool IsMountSdCardEnabled() NN_NOEXCEPT;

    enum SdCardCidState
    {
        Real        = 0,
        Same        = 1,
        Different   = 2
    };
    SdCardCidState GetSdCardCidState() NN_NOEXCEPT;

    Result GetMountGameCardResultForDebug() NN_NOEXCEPT;
    Result GetCleanupSdCardResultForDebug() NN_NOEXCEPT;
    Result GetTryGameCardAccessResultForDebug() NN_NOEXCEPT;
    Result GetCleanupAddOnContentWithNoRightsResultForDebug() NN_NOEXCEPT;
    util::optional<Bit64> GetDebugSystemUpdateMetaIdForSystemDeliveryInfo() NN_NOEXCEPT;
    bool IsCleanupOrphanCacheStorageEnabledForDebug() NN_NOEXCEPT;
    void GetApplicationInfoOnBlackListForDebug(ncm::ApplicationId* outId, uint32_t* outVersion) NN_NOEXCEPT;
    util::optional<int> GetLicenseTypeForDebug() NN_NOEXCEPT;
    bool IsDebugELicenseImportEnabled() NN_NOEXCEPT;
}}}
