﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentInfoData.h>

#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationVerificationTypes.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_TicketManager.h>

#include <nn/os/os_Thread.h>
#include <nn/os/os_TransferMemory.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_Types.h>
#include <nn/util/util_Optional.h>

#include "ns_AsyncImpl.h"
#include "ns_Config.h"
#include "ns_ThreadAllocator.h"

namespace nn { namespace ns { namespace srv {
    class AsyncVerifyApplicationImpl : public ProgressAsyncResultBase
    {
    public:
        ~AsyncVerifyApplicationImpl() NN_NOEXCEPT;

        Result Initialize(ncm::ApplicationId appId, VerifyContentFlag flags, ApplicationRecordDatabase* pRecordDb, const IntegratedContentManager* pIntegrated, RequestServer::ManagedStop&& stopper, sf::NativeHandle transferHandle, size_t size) NN_NOEXCEPT;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }

    private:
        Result Execute() NN_NOEXCEPT;

        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetProgressImpl(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetDetailResultImpl() NN_NOEXCEPT NN_OVERRIDE;

        Result CalcContentFileHash(ncm::Hash* outValue, const nn::ncm::ContentId& contentId, ncm::StorageId storageId) NN_NOEXCEPT;

        void SetSumSize(int64_t size) NN_NOEXCEPT;
        void AddCurrentOffset(int64_t offset) NN_NOEXCEPT;

        Result m_Result;
        ManualClearSystemEvent m_Event;
        ManualClearEvent m_EndEvent;
        mutable NonRecursiveMutex m_StateLock;
        util::optional<os::TransferMemory> m_Transfer;

        util::optional<ThreadInfo> m_ThreadInfo;

        ApplicationRecordDatabase* m_pRecordDb;
        const IntegratedContentManager* m_pIntegrated;
        RequestServer::ManagedStop m_Stopper;
        ncm::ApplicationId m_AppId;
        VerifyContentFlag m_Flags;
        void* m_Buffer;
        size_t m_BufferSize;
        int64_t m_SumSize;
        int64_t m_CurrentOffset;
        Result m_DetailResult;
    };

    class AsyncVerifyAddOnContentsImpl : public ProgressAsyncResultBase
    {
    public:
        ~AsyncVerifyAddOnContentsImpl() NN_NOEXCEPT;

        Result Initialize(ncm::ApplicationId appId, IntegratedContentManager* pIntegrated, ApplicationRecordDatabase* pRecordDb, TicketManager* pTicketManager) NN_NOEXCEPT;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }

    private:
        Result Execute() NN_NOEXCEPT;

        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetProgressImpl(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetDetailResultImpl() NN_NOEXCEPT NN_OVERRIDE;

        Result m_Result;
        ManualClearSystemEvent m_Event;
        ManualClearEvent m_EndEvent;
        mutable NonRecursiveMutex m_StateLock;

        util::optional<ThreadInfo> m_ThreadInfo;

        IntegratedContentManager* m_pIntegrated;
        ApplicationRecordDatabase* m_pRecordDb;
        TicketManager* m_pTicketManager;
        ncm::ApplicationId m_AppId;
        int m_Total;
        int m_Current;
        Result m_DetailResult;
    };

}}}

