﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nim/nim_Result.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/settings/system/settings_Language.h>
#include <nn/ns/srv/ns_ApplicationControlDataManager.h>
#include "ns_ApplicationControlFileUtil.h"
#include "ns_AsyncDownloadApplicationControlDataImpl.h"

namespace nn { namespace ns { namespace srv {
    Result AsyncDownloadApplicationControlDataImpl::Initialize(ncm::ApplicationId id) NN_NOEXCEPT
    {
        m_Id = id;
        NN_RESULT_TRY(nim::RequestLatestApplicationControl(&m_AsyncApplicationControlInfo, id))
            NN_RESULT_CATCH_CONVERT(nim::ResultOutOfMaxTask, ResultOutOfMaxRunningTask())
            NN_RESULT_CATCH_CONVERT(nim::ResultOutOfMaxRunningTask, ResultOutOfMaxRunningTask())
        NN_RESULT_END_TRY
        NN_RESULT_SUCCESS;
    }

    Result AsyncDownloadApplicationControlDataImpl::GetImpl() NN_NOEXCEPT
    {
        nim::ApplicationControlInfo info;
        NN_RESULT_TRY(SaveErrorContextIfFailed(m_AsyncApplicationControlInfo, m_AsyncApplicationControlInfo.Get(&info)))
            NN_RESULT_CATCH(nim::ResultHttpStatus404NotFound) { NN_RESULT_THROW(ResultApplicationControlNotDelivered()); }
        NN_RESULT_END_TRY

        // TORIAEZU: ProgramIndex == 0 のアプリケーション管理データを落としてくる想定
        NN_RESULT_DO(m_Manager->PutPath(m_Id, info.version, 0, info.path, false));
        NN_RESULT_SUCCESS;
    }

    os::SystemEvent& AsyncDownloadApplicationControlDataImpl::GetEvent() NN_NOEXCEPT
    {
        return m_AsyncApplicationControlInfo.GetEvent();
    }
}}}
