﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_Language.h>
#include <nn/util/util_Optional.h>
#include <nn/ns/detail/ns_ApplicationLanguage.h>

namespace nn { namespace ns { namespace srv {

//-----------------------------------------------------------------------------

static const int LanguagePriorityListLength = 15;

const ns::detail::ApplicationLanguage* GetLanguagePriorityList(ns::detail::ApplicationLanguage language) NN_NOEXCEPT;

util::optional<ns::detail::ApplicationLanguage> ToApplicationLanguage(const settings::LanguageCode& language) NN_NOEXCEPT;

util::optional<settings::LanguageCode> MakeLanguageCode(ns::detail::ApplicationLanguage language) NN_NOEXCEPT;

const char* GetApplicationLanguageString(ns::detail::ApplicationLanguage language) NN_NOEXCEPT;

//-----------------------------------------------------------------------------

}}} // namespace nn::ns::service
