﻿// インターフェイスの定義ファイル
// C# で記述します。

// 以下の using ディレクティブを記述しておくと便利です。
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.nsd
{
    [CppRefPath("<nn/nsd/nsd_Types.h>")]
    [ExternalStruct(256, 1)]
    [LargeData(true)]
    public struct SettingName
    {
    }

    [CppRefPath("<nn/nsd/nsd_Types.h>")]
    [ExternalStruct(8, 1)]
    [LargeData(true)]
    public struct EnvironmentIdentifier
    {
    }

    [CppRefPath("<nn/nsd/nsd_TypesPrivate.h>")]
    [ExternalStruct(16, 1)]
    public struct DeviceId
    {
    }

    [CppRefPath("<nn/nsd/nsd_Types.h>")]
    [ExternalStruct(256, 1)]
    [LargeData(true)]
    public struct Fqdn
    {
    }

    [CppRefPath("<nn/nsd/nsd_TypesPrivate.h>")]
    [ExternalStruct(4, 4)]
    public struct InnerResult
    {
    }

    [CppRefPath("<nn/nsd/nsd_BackboneSettingsTypes.h>")]
    [ExternalStruct(264, 8)]
    [LargeData(true)]
    public struct NasServiceSetting
    {
    }

    [CppRefPath("<nn/nsd/nsd_BackboneSettingsTypes.h>")]
    [ExternalStruct(16, 1)]
    [LargeData(true)]
    public struct NasServiceName
    {
    }

    [CppRefPath("<nn/nsd/nsd_TypesPrivate.h>")]
    [ExternalStruct(76784, 8)]
    [LargeData(true)]
    public struct SaveData
    {
    }
}

namespace nn.nsd.detail
{
    public interface IManager : IServiceObject
    {
        //---------------- APiForMenu の API
        // 設定名の取得
        [MethodId(10)]
        Result GetSettingName(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<SettingName> pOut );

        // 環境識別子の取得
        [MethodId(11)]
        Result GetEnvironmentIdentifier(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<EnvironmentIdentifier> pOut );

        [MethodId(12)]
        Result GetDeviceId(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<DeviceId> pOut );

        // サービスディスカバリ設定を削除
        [MethodId(13)]
        Result DeleteSettings( int32_t deleteMode );

        // サービスディスカバリ設定を保存
        [MethodId(14)]
        Result ImportSettings(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]InBuffer pBuffer,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]OutBuffer pWorkBuffer,
                             int32_t importMode );

        [MethodId(15)]
        Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled);

        //---------------- APiForMiddleware の API
        // FQDN 解決
        [MethodId(20)]
        Result Resolve(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<Fqdn> pOut,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Fqdn fqdn );

        // FQDN 解決(エラーハンドリングなし)
        [MethodId(21)]
        Result ResolveEx(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<InnerResult> pInnerResult,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<Fqdn> pOut,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Fqdn fqdn );

        //---------------- APiForNasService の API
        // NAS サービスを利用するための設定を取得
        [MethodId(30)]
        Result GetNasServiceSetting(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<NasServiceSetting> pOutNasServiceSetting,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]NasServiceName nasServiceName );

        // NAS サービスを利用するための設定を取得(エラーハンドリングなし)
        [MethodId(31)]
        Result GetNasServiceSettingEx(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<InnerResult> pInnerResult,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<NasServiceSetting> pOutNasServiceSetting,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]NasServiceName nasServiceName );


        //---------------- APIForNasServicePrivate の API
        // NAS の認証・トークン取得リクエスト用の fqdn 取得
        [MethodId(40)]
        Result GetNasRequestFqdn(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<Fqdn> pOut );

        // NAS の認証・トークン取得リクエスト用の fqdn 取得(エラーハンドリングなし)
        [MethodId(41)]
        Result GetNasRequestFqdnEx(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<InnerResult> pInnerResult,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<Fqdn> pOut );

        // NAS の API 用の fqdn を取得
        [MethodId(42)]
        Result GetNasApiFqdn(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<Fqdn> pOut );

        // NAS の API 用の fqdn を取得(エラーハンドリングなし)
        [MethodId(43)]
        Result GetNasApiFqdnEx(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<InnerResult> pInnerResult,
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<Fqdn> pOut );

        //---------------- ApiForDevmenuCommand の API
        [MethodId(50)]
        Result GetCurrentSetting(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<SaveData> pSaveData );

        //---------------- ApiForTest の API (nsd:a 必須)
        [MethodId(60)]
        Result ReadSaveDataFromFsForTest(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]Out<SaveData> pOut );

        [MethodId(61)]
        Result WriteSaveDataToFsForTest(
                             [BufferTransferMode(BufferTransferMode.MapAlias)]SaveData saveData );

        [MethodId(62)]
        Result DeleteSaveDataOfFsForTest();

        [MethodId(63)]
        Result IsChangeEnvironmentIdentifierDisabled(Out<bool> outValue);
    }
}
