﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_VulnerabilityApi.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ShimLibraryUtility.h>

#include <nn/ns/detail/ns_Log.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {

    bool NeedsUpdateVulnerability() NN_NOEXCEPT
    {
        bool value;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetVulnerabilityManagerInterface()->NeedsUpdateVulnerability(&value));
        return value;
    }

    void UpdateSafeSystemVersionForDebug(ncm::SystemUpdateId id, uint32_t version) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetVulnerabilityManagerInterface()->UpdateSafeSystemVersionForDebug(id, version));
    }

    void GetSafeSystemVersion(ncm::ContentMetaKey* out) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetVulnerabilityManagerInterface()->GetSafeSystemVersion(out));
    }
}}
