﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <utility>
#include <nn/ns/ns_RequestServerStopper.h>
#include <nn/nn_Abort.h>

namespace nn { namespace ns {
    RequestServerStopper::RequestServerStopper() NN_NOEXCEPT
        : m_Interface()
    {
    }

    RequestServerStopper::RequestServerStopper(
        sf::SharedPointer<detail::IRequestServerStopper> interface) NN_NOEXCEPT
        : m_Interface(interface)
    {
    }

    RequestServerStopper::RequestServerStopper(
        RequestServerStopper&& rvalue) NN_NOEXCEPT
    {
        m_Interface = std::move(rvalue.m_Interface);
    }

    RequestServerStopper& RequestServerStopper::operator=(
        RequestServerStopper&& rvalue) NN_NOEXCEPT
    {
        RequestServerStopper(std::move(rvalue)).swap(*this);

        return *this;
    }

    void RequestServerStopper::swap(RequestServerStopper& other) NN_NOEXCEPT
    {
        std::swap(m_Interface, other.m_Interface);
    }
}} // ~nn::ns

