﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <type_traits>
#include <nn/fs/fs_Content.h>
#include <nn/ns/ns_DocumentApi.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ShimLibraryUtility.h>

#include "ns_Initialize.h"

namespace nn { namespace ns {

namespace {
    // TORIAEZU: 必要とする人が出るまで公開しない
    Result GetRunningApplicationProgramId(ncm::ProgramId* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        ncm::ProgramId programId;
        NN_RESULT_DO(GetDocumentInterface()->GetRunningApplicationProgramId(&programId, id));
        *outValue = programId;
        NN_RESULT_SUCCESS;
    }
}

    Result MountApplicationHtmlDocument(const char* mountName, ncm::ApplicationId id) NN_NOEXCEPT
    {
        ncm::ProgramId programId;
        NN_RESULT_DO(GetRunningApplicationProgramId(&programId, id));

        // HtmlDocument はパッチを当てるため、ここではパス解決をしない
        // ns で lr に登録をしてもらったうえで、fs でマウントしてもらう
        NN_RESULT_DO(GetDocumentInterface()->ResolveApplicationContentPath(programId, ncm::ContentType::HtmlDocument));
        NN_RESULT_DO(fs::MountContent(mountName, programId, nn::fs::ContentType_Manual));

        NN_RESULT_SUCCESS;
    }

    Result MountApplicationLegalInformation(const char* mountName, ncm::ApplicationId id) NN_NOEXCEPT
    {
        ncm::Path path;
        NN_RESULT_DO(GetDocumentInterface()->GetApplicationContentPath(&path, id, ncm::ContentType::LegalInformation));
        NN_RESULT_DO(fs::MountContent(mountName, path.string, id, nn::fs::ContentType_Manual));

        NN_RESULT_SUCCESS;
    }

}}
