﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_ApplicationViewApi.h>
#include <nn/ns/ns_ApplicationViewSystemApi.h>

#include "ns_Initialize.h"

namespace nn { namespace ns {

    Result GetApplicationView(ApplicationView outList[], const ncm::ApplicationId idList[], int count) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetApplicationView(sf::OutArray<ApplicationView>(outList, count), sf::InArray<ncm::ApplicationId>(idList, count));
    }

    Result GetApplicationViewDownloadErrorContext(err::ErrorContext* outValue, const ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetApplicationViewDownloadErrorContext(outValue, id);
    }

    bool ApplicationView::HasRecord() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasRecord>();
    }

    bool ApplicationView::HasMainRecord() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasMainRecord>();
    }

    bool ApplicationView::HasPatchRecord() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasPatchRecord>();
    }

    bool ApplicationView::HasAddOnContentRecord() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasAddOnContentRecord>();
    }

    bool ApplicationView::HasMainInstallRecord() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasMainInstallRecord>();
    }

    bool ApplicationView::IsDownloading() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_Downloading>();
    }

    bool ApplicationView::IsGameCard() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_IsGameCard>();
    }

    bool ApplicationView::HasGameCardEntity() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasGameCardEntity>();
    }

    bool ApplicationView::IsLaunchable() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_IsLaunchable>();
    }

    bool ApplicationView::HasAllEntity() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasAllEntity>();
    }

    bool ApplicationView::HasMainEntity() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasMainEntity>();
    }

    bool ApplicationView::HasAllAddOnContentEntity() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasAllAddOnContentEntity>();
    }
    bool ApplicationView::HasAnyAddOnContentEntity() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasAnyAddOnContentEntity>();
    }
    bool ApplicationView::HasPatchEntity() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_HasPatchEntity>();
    }

    bool ApplicationView::MaybeCorrupted() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_MaybeCorrupted>();
    }

    bool ApplicationView::IsWaitingCommit() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_WaitingApplicationCommit>() ||
            flag.Test<ApplicationViewFlag_WaitingAocCommit>() ||
            flag.Test<ApplicationViewFlag_WaitingPatchInstall>();
    }

    bool ApplicationView::IsWaitingApplicationCommit() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_WaitingApplicationCommit>();
    }

    bool ApplicationView::IsWaitingAocCommit() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_WaitingAocCommit>();
    }

    bool ApplicationView::IsWaitingPatchInstall() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_WaitingPatchInstall>();
    }

    bool ApplicationView::IsAutoDeleteDisabled() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_AutoDeleteDisabled>();
    }
    bool ApplicationView::IsApplyingDelta() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_ApplyingDelta>();
    }
    bool ApplicationView::IsCleanupAddOnContentWithNoRightsRecommended() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_IsCleanupAddOnContentWithNoRightsRecommended>();
    }
    bool ApplicationView::IsSystemUpdateRequiredToCommit() const NN_NOEXCEPT
    {
        return IsWaitingCommit() && progress.state == ApplicationDownloadState::SystemUpdateRequired;
    }
    bool ApplicationView::IsPreInstalledApplication() const NN_NOEXCEPT
    {
        return flag.Test<ApplicationViewFlag_IsPreInstalledApplication>();
    }

    Result ListApplicationDownloadingContentMeta(int* outCount, ncm::StorageContentMetaKey outList[], int count, ncm::ApplicationId id, int offset) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ListApplicationDownloadingContentMeta(outCount, sf::OutArray<ncm::StorageContentMetaKey>(outList, count), id, offset);
    }

    Result GetApplicationDownloadTaskStatus(ApplicationDownloadTaskStatus* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetApplicationDownloadTaskStatus(outValue, id);
    }
}}
