﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ns/ns_ApplicationRecordApi.h>
#include <nn/ns/ns_ApplicationRecordSystemApi.h>
#include <nn/result/result_HandlingUtility.h>

#include "ns_Initialize.h"

namespace nn { namespace ns {
    int ListApplicationRecord(ApplicationRecord outValue[], int count, int offset) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->ListApplicationRecord(&outCount, sf::OutArray<ApplicationRecord>(outValue, count), offset));

        return outCount;
    }

    Result TouchApplication(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->TouchApplication(id);
    }

    int64_t GenerateApplicationRecordCount() NN_NOEXCEPT
    {
        int64_t count;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GenerateApplicationRecordCount(&count));

        return count;
    }

    void GetApplicationRecordUpdateSystemEvent(os::SystemEvent* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetApplicationRecordUpdateSystemEvent(&nativeHandle));
        outValue->AttachReadableHandle(nativeHandle.GetOsHandle(), nativeHandle.IsManaged(), os::EventClearMode_AutoClear);
        nativeHandle.Detach();
    }

    Result DisableApplicationAutoDelete(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DisableApplicationAutoDelete(id);
    }

    Result EnableApplicationAutoDelete(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->EnableApplicationAutoDelete(id);
    }

    Result PushApplicationRecord(ncm::ApplicationId id, ApplicationEvent appEvent, const ncm::StorageContentMetaKey keyList[], int count) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->PushApplicationRecord(id, appEvent, sf::InArray<ncm::StorageContentMetaKey>(keyList, count));
    }

    Result ListApplicationRecordContentMeta(int* outCount, ncm::StorageContentMetaKey outList[], int count, ncm::ApplicationId id, int offset) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ListApplicationRecordContentMeta(outCount, sf::OutArray<ncm::StorageContentMetaKey>(outList, count), id, offset);
    }

    Result ListApplicationRecordInstalledContentMeta(int* outCount, ncm::StorageContentMetaKey outList[], int count, ncm::ApplicationId id, int offset) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ListApplicationRecordInstalledContentMeta(outCount, sf::OutArray<ncm::StorageContentMetaKey>(outList, count), id, offset);
    }

    Result DeleteApplicationRecord(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DeleteApplicationRecord(id);
    }

    Result GetApplicationRecord(ApplicationRecord* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetApplicationRecord(outValue, id);
    }

    Result GetApplicationRecordProperty(ApplicationRecordProperty* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->GetApplicationRecordProperty(outValue, id);
    }

    Result EnableApplicationAutoUpdate(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->EnableApplicationAutoUpdate(id);
    }

    Result DisableApplicationAutoUpdate(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->DisableApplicationAutoUpdate(id);
    }

    Result RequestApplicationUpdate(ncm::ApplicationId id, Result reason) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->RequestApplicationUpdate(id, reason.GetInnerValueForDebug());
    }

    Result IsApplicationUpdateRequested(util::optional<Result>* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        bool isRequested;
        Bit32 innerValue;
        NN_RESULT_DO(GetApplicationManagerInterface()->IsApplicationUpdateRequested(&isRequested, &innerValue, id));
        *outValue = isRequested ? util::optional<Result>(result::detail::ConstructResult(innerValue)) : util::nullopt;
        NN_RESULT_SUCCESS;
    }

    Result WithdrawApplicationUpdateRequest(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->WithdrawApplicationUpdateRequest(id);
    }

    Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->WithdrawCleanupAddOnContentsWithNoRightsRecommendation(id);
    }

    bool HasApplicationRecord(ncm::ApplicationId id) NN_NOEXCEPT
    {
        bool value;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetReadOnlyApplicationRecordInterface()->HasApplicationRecord(&value, id));
        return value;
    }

    Result SetPreInstalledApplication(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->SetPreInstalledApplication(id);
    }

    Result ClearPreInstalledApplicationFlag(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ClearPreInstalledApplicationFlag(id);
    }
}}
