﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nim/srv/nim_DeviceAuthenticationTokenInfoCache.h>

namespace nn { namespace nim { namespace srv {

    void DeviceAuthenticationTokenInfoCache::Save(const DeviceAuthenticationTokenInfo& token) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_Mutex);

        SimpleDataCache::Save(token);
    };

    void DeviceAuthenticationTokenInfoCache::Clear() NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_Mutex);

        SimpleDataCache::Clear();
    }

    bool DeviceAuthenticationTokenInfoCache::Get(DeviceAuthenticationTokenInfo* outValue) NN_NOEXCEPT
    {
        std::lock_guard<os::Mutex> guard(m_Mutex);

        return SimpleDataCache::Get(outValue);
    }
}}}
