﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/srv/nim_DeviceAccountStore.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_EciAccessor.h>
#include <nn/os/os_Mutex.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    class AsyncSyncTicketImpl : public AsyncResultImpl<AsyncSyncTicketImpl>
    {
    public:
        explicit AsyncSyncTicketImpl(DeviceAccountStore* store) NN_NOEXCEPT;
        ~AsyncSyncTicketImpl() NN_NOEXCEPT;

        Result Initialize(DeviceContext* deviceContext) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        Result GetProgress(sf::Out<AsyncProgress> outValue) NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        void SetProgress(AsyncProgress progress) NN_NOEXCEPT
        {
            std::lock_guard<os::Mutex> guard(m_Mutex);
            m_Progress = progress;
        }

        AsyncProgress GetProgress() NN_NOEXCEPT
        {
            std::lock_guard<os::Mutex> guard(m_Mutex);
            return m_Progress;
        }

        // サポートする最大のチケット所有数
        static const int MaxTicketCount = 8000;

        char* m_WorkBuffer {};
        DeviceContext* m_DeviceContext;
        HttpConnection m_Connection;
        DeviceAccountStore* m_Store;
        os::Mutex m_Mutex;
        AsyncProgress m_Progress;
    };

}}}
