﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/srv/nim_ThreadAllocator.h>
#include <nn/result/result_HandlingUtility.h>
#include "nim_AsyncLatestVersionImpl.h"
#include "nim_NetworkInstallUtil.h"
#include "nim_SystemUpdateMetaUtil.h"

namespace nn { namespace nim { namespace srv {

    namespace
    {
        static const int LatestVersionThreadCount = 1;
        static const size_t StackSize = 16 * 1024;

        os::ThreadType g_LatestVersionThreadList[LatestVersionThreadCount];
        NN_OS_ALIGNAS_THREAD_STACK char g_LatestVersionStack[StackSize * LatestVersionThreadCount];

        ThreadAllocator g_LatestVersionThreadAllocator(g_LatestVersionThreadList, LatestVersionThreadCount, NN_SYSTEM_THREAD_PRIORITY(nim, LatestVersionTask), g_LatestVersionStack, sizeof(g_LatestVersionStack), StackSize, NN_SYSTEM_THREAD_NAME(nim, LatestVersionTask));
    }

    AsyncLatestVersionImpl::AsyncLatestVersionImpl() NN_NOEXCEPT : AsyncResultImpl<AsyncLatestVersionImpl>(this, &g_LatestVersionThreadAllocator), m_ApplicationId(), m_LatestCount() {}


    Result AsyncLatestVersionImpl::Initialize(DeviceContext* deviceContext, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        NN_RESULT_DO(m_Connection.Initialize(deviceContext));

        m_ApplicationId = appId;
        m_DeviceId = deviceContext->GetDeviceId();
        NN_RESULT_SUCCESS;
    }

    Result AsyncLatestVersionImpl::Execute() NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckSystemUpdateMetaForContentDelivery(&m_Connection, m_DeviceId));
        NN_RESULT_DO(GetLatestContentMetaKey(m_LatestKeyList, &m_LatestCount, MaxKeyCount, &m_Connection, m_ApplicationId.value));

        NN_RESULT_SUCCESS;
    }

    Result AsyncLatestVersionImpl::Cancel() NN_NOEXCEPT
    {
        m_Connection.Cancel();
        NN_RESULT_SUCCESS;
    }

    Result AsyncLatestVersionImpl::GetSize(sf::Out<std::uint64_t> outValue) NN_NOEXCEPT
    {
        *outValue = GetSizeImpl();
        NN_RESULT_SUCCESS;
    }

    Result AsyncLatestVersionImpl::Get(const sf::OutBuffer& buffer) const NN_NOEXCEPT
    {
        NN_RESULT_DO(AsyncResultImpl<AsyncLatestVersionImpl>::Get());
        NN_RESULT_THROW_UNLESS(GetSizeImpl() <= buffer.GetSize(), ResultBufferNotEnough());
        std::memcpy(buffer.GetPointerUnsafe(), m_LatestKeyList, GetSizeImpl());
        NN_RESULT_SUCCESS;
    }

}}}
