﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/nim_GameCardRegistrationStatus.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/account/account_ConfigForSystemServices.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    namespace detail
    {
        const char AuthorizationHeaderPrefix[] = "Authorization: Bearer ";
        const size_t AuthorizationHeaderSize = sizeof(detail::AuthorizationHeaderPrefix) + account::NintendoAccountIdTokenLengthMax;
    }

    class ApplicationIdList
    {
    public:
        ApplicationIdList() NN_NOEXCEPT : m_Count(0)
        {
        }

        void Initialize(const ncm::ApplicationId appIdList[], int count) NN_NOEXCEPT;
        ncm::ApplicationId operator[](int index) const NN_NOEXCEPT;
        int GetCount() const NN_NOEXCEPT;

    private:
        std::array<ncm::ApplicationId, MaxRegisterableApplicationCount> m_AppIdList;
        int m_Count;
    };

    class AsyncGameCardRegistrationStatusImpl : public AsyncValueImpl<AsyncGameCardRegistrationStatusImpl, GameCardRegistrationStatus>
    {
    public:
        AsyncGameCardRegistrationStatusImpl() NN_NOEXCEPT;
        ~AsyncGameCardRegistrationStatusImpl() NN_NOEXCEPT
        {
            AsyncValueImpl<AsyncGameCardRegistrationStatusImpl, GameCardRegistrationStatus>::Join();
        }

        Result Initialize(DeviceContext* deviceContext, const ncm::ApplicationId appIdList[], int appIdCount, const char* token, const void* cert, size_t certSize) NN_NOEXCEPT;
        Result ExecuteAndValue(GameCardRegistrationStatus* outValue) NN_NOEXCEPT;
        Result CancelImpl() NN_NOEXCEPT
        {
            m_Connection.Cancel();
            NN_RESULT_SUCCESS;
        }
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        void InitializeAuthorizationHeaderAndNeedGoldpointResponseFlag(const char* token) NN_NOEXCEPT;
        HttpConnection m_Connection;
        char m_CertBase64[1024];
        char m_AuthorizationHeader[detail::AuthorizationHeaderSize];
        bool m_NeedGoldpointResponse;
        ApplicationIdList m_AppIdList;
    };

    class AsyncRegisterGameCardImpl : public AsyncResultImpl<AsyncRegisterGameCardImpl>
    {
    public:
        Result Initialize(DeviceContext* deviceContext, const ncm::ApplicationId appIdList[], int appIdCount, const char* token, const void* cert, size_t certSize, GameCardRegistrationStatus status) NN_NOEXCEPT;
        AsyncRegisterGameCardImpl() NN_NOEXCEPT;
        ~AsyncRegisterGameCardImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncRegisterGameCardImpl>::Join();
        }
        Result Execute() NN_NOEXCEPT;

        Result Cancel() NN_NOEXCEPT
        {
            m_Connection.Cancel();
            NN_RESULT_SUCCESS;
        }
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        HttpConnection m_Connection;
        char m_CertBase64[1024];
        char m_AuthorizationHeader[detail::AuthorizationHeaderSize];
        GameCardRegistrationStatus m_Status;
        ApplicationIdList m_AppIdList;
    };
}}}
