﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_ApiSystemAvailability.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>

namespace nn
{
namespace nifm
{
namespace detail
{
nn::Result GetGeneralServicePointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT;
}

nn::Result ConfirmSystemAvailability() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetGeneralServicePointer(&pGeneralService));

    NN_RESULT_DO(pGeneralService->ConfirmSystemAvailability());

    NN_RESULT_SUCCESS;
}

}
}

