﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/service/nifm_TemporaryNetworkProfileImpl.h>

#include <nn/nifm/detail/core/profile/nifm_NetworkProfileManager.h>
#include <nn/nifm/detail/util/nifm_SfUtility.h>


namespace nn
{
namespace nifm
{
namespace detail
{

TemporaryNetworkProfileImpl::~TemporaryNetworkProfileImpl() NN_NOEXCEPT
{
    if (nn::util::InvalidUuid != m_Id)
    {
        nn::Result result = m_pNetworkProfileManager->RemoveNetworkProfile(NetworkProfileBase::ProfileType::TemporaryProfile, m_Id);
        NN_SDK_ASSERT(result.IsSuccess());
        NN_UNUSED(result);
    }
}

Result TemporaryNetworkProfileImpl::Update( nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const sf::NetworkProfileData& networkProfileData ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_pNetworkProfileManager);
    NN_SDK_REQUIRES_NOT_EQUAL(nn::util::InvalidUuid, m_Id);

    NN_RESULT_DO(m_pNetworkProfileManager->RemoveNetworkProfile(NetworkProfileBase::ProfileType::TemporaryProfile, m_Id));
    m_Id = nn::util::InvalidUuid;

    NetworkProfileData profile;
    ConvertNetworkProfileDataToNifmFromSf( &profile, networkProfileData );
    profile.id = nn::util::InvalidUuid; // ID を持つ接続設定の上書き防止

    NN_RESULT_DO(m_pNetworkProfileManager->AddTemporaryNetworkProfile(&m_Id, profile));
    outNetworkProfileId.Set(m_Id);

    NN_RESULT_SUCCESS;
}

Result TemporaryNetworkProfileImpl::PersistOld(nn::sf::Out<nn::util::Uuid> newId, const nn::util::Uuid id) NN_NOEXCEPT
{
    NN_UNUSED(id);

    return Persist(newId);
}

Result TemporaryNetworkProfileImpl::Persist(nn::sf::Out<nn::util::Uuid> newId) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(m_Capability.isProfileEditable, ResultNoCapability());
    NN_RESULT_DO(m_pNetworkProfileManager->PerpetuateTemporaryNetworkProfile(newId.GetPointer(), m_Id));
    m_Id = newId.Get();
    NN_RESULT_DO(m_pNetworkProfileManager->ExportUserNetworkProfile());

    NN_RESULT_SUCCESS;
}

}
}
}
