﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/service/nifm_ServiceProvider.h>

#include <nn/wlan/wlan_InfraApi.h>
#include <nn/tsc.h>
#include <nn/socket/socket_Api.h>
#include <nn/socket/socket_SystemConfig.h>
#include <nn/bgtc/bgtc_StateControlApi.h>

#include <nn/settings/system/settings_WirelessLan.h>

#if defined(NN_DETAIL_NIFM_CONFIG_CONNECTION_CONFIRMATION_ENABLED)
#include <curl/curl.h>
#endif


namespace nn
{
namespace nifm
{
namespace detail
{

namespace
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    // ================ TODO: SIGLO-25667 ==================
    // 疎通確認で socket の free が間に合わないタイミングで次の socket を生成することがある
    // 問題の一時的回避用にメモリを 2 倍確保
    nn::socket::SystemConfigLightDefaultWithMemory<
        2, // max TCP sockets
        0  // max UDP sockets
     > g_SocketConfigWithMemory;
#endif
}

ServiceProvider::GeneralArranger::GeneralArranger() NN_NOEXCEPT
{
    // 各コンポーネントの初期化前に必要な処理をここに書く
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_DETAIL_NIFM_INFO("NIFM service under preparation...\n");

#if NN_DETAIL_NIFM_CONFIG_USE_WLAN_LIBRARY
    nn::wlan::InitializeInfraManager();
#endif
    nn::tsc::Initialize();
#endif

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::socket::Initialize(g_SocketConfigWithMemory);
    nn::bgtc::InitializeStateControl();
#if defined(NN_DETAIL_NIFM_CONFIG_CONNECTION_CONFIRMATION_ENABLED)
    curl_global_init(CURL_GLOBAL_DEFAULT);
#endif
#endif
}

ServiceProvider::GeneralArranger::~GeneralArranger() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::bgtc::FinalizeStateControl();
#if defined(NN_DETAIL_NIFM_CONFIG_CONNECTION_CONFIRMATION_ENABLED)
    curl_global_cleanup();
#endif
    nn::socket::Finalize();
#endif

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::tsc::Finalize();
#if NN_DETAIL_NIFM_CONFIG_USE_WLAN_LIBRARY
    nn::wlan::FinalizeInfraManager();
#endif
    NN_DETAIL_NIFM_INFO("NIFM service closed.\n");
#endif
}

ServiceProvider::ServiceProvider() NN_NOEXCEPT
    : m_GeneralArranger(),
      m_NetworkProfileManager(),
      m_ConnectionSelector(&m_NetworkProfileManager),
      m_WirelessInterface(),
      m_EthernetInterfaceManager(&m_ConnectionSelector),
      m_RequestManager(),
      m_PowerStateCoordinator(&m_RequestManager, &m_ConnectionSelector, &m_EthernetInterfaceManager),
      m_DispatchLoop(&m_RequestManager, &m_ConnectionSelector, &m_EthernetInterfaceManager, &m_NetworkProfileManager, &m_PowerStateCoordinator),
      m_HipcServerManager(this),
      m_IsWirelessCommunicationEnabled(true)
{
    // TODO: [TORIAEZU] 最初の無線 NIC を見つけて登録する

#if NN_DETAIL_NIFM_CONFIG_USE_WLAN_LIBRARY
    {
        MacAddress macAddresses[1];
        int32_t outCount;

        WirelessInterface::GetAllMacAddresses( macAddresses, &outCount, 1 );
        if( outCount > 0 )
        {
            m_WirelessInterface.Initialize( macAddresses[0] );
            if( m_WirelessInterface.IsAvailable() )
            {
                m_ConnectionSelector.Register( &m_WirelessInterface );
            }
        }
    }
#endif  // NN_DETAIL_NIFM_CONFIG_USE_WLAN_LIBRARY

    m_WirelessInterface.SetEnabled(nn::settings::system::IsWirelessLanEnabled());

    m_DispatchLoop.Start();
}

ServiceProvider::~ServiceProvider() NN_NOEXCEPT
{
    m_DispatchLoop.Stop();
}

nn::Result ServiceProvider::Start() NN_NOEXCEPT
{
#if NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_NIFM_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    NN_DETAIL_NIFM_INFO("NIFM service ready.\n");
#endif
    m_HipcServerManager.MyLoopAuto();

    // TODO:終了処理
    // ...
#endif

    NN_RESULT_SUCCESS;
}

}
}
}
