﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "./ngc_ErrnoT.h"
#include "./ngc_MemoryInputStream.h"

//
// MemoryInputStream.h
//
namespace nn { namespace ngc { namespace detail {

MemoryInputStream::~MemoryInputStream() NN_NOEXCEPT
{
    this->Close();
}

MemoryInputStream::MemoryInputStream(const void* buf, size_t n) NN_NOEXCEPT
    : m_pMisBuf(reinterpret_cast<const uint8_t*>(buf)), m_pMisSize(n) {}

errno_t MemoryInputStream::Init(const void* buf, size_t n) NN_NOEXCEPT
{
    if (!m_pMisBuf)
    {
        m_pMisBuf = reinterpret_cast<const uint8_t*>(buf);
        m_pMisSize = n;
        return 0;
    }
    else
    {
        return EALREADY;
    }
}

size_t MemoryInputStream::FillBuffer_(void* p, size_t nbytes) NN_NOEXCEPT
{
    if (!m_pMisBuf)
    {
        this->SetError(ENOMEM);
        return 0;
    }
    NN_UNUSED(nbytes);
    if (!p)
    {
        InputStream::ResetBuffer(const_cast<uint8_t*>(m_pMisBuf), m_pMisSize);
        return m_pMisSize;
    }
    else
    {
        return 0;
    }
}

}}} // nn::ngc::detail
