﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <utility>  // for std::move

#include "./ngc_Util.h"

// errno 関連
namespace nn { namespace ngc { namespace detail {

class ErrnoT final
{
public:
    ErrnoT() NN_NOEXCEPT {}
    ErrnoT(errno_t e) NN_NOEXCEPT : m_VsErrno(e) {}  // NOLINT
    ErrnoT& operator=(errno_t e) NN_NOEXCEPT
    {
        m_VsErrno = e;
        return *this;
    }
    NN_EXPLICIT_OPERATOR errno_t() const NN_NOEXCEPT
    {
        return m_VsErrno;
    }

private:
    // to suppress the mix-up with boolean value
    bool operator!() const;  // FORBIDDEN
    // operator bool() const;  // FORBIDDEN
    errno_t m_VsErrno;
};

inline bool operator==(const ErrnoT& lhs, errno_t rhs) NN_NOEXCEPT
{
    return lhs.operator errno_t() == rhs;
}

inline bool operator==(errno_t lhs, const ErrnoT& rhs) NN_NOEXCEPT
{
    return rhs.operator errno_t() == lhs;
}

inline bool operator!=(const ErrnoT& lhs, errno_t rhs) NN_NOEXCEPT
{
    return lhs.operator errno_t() != rhs;
}

inline bool operator!=(errno_t lhs, const ErrnoT& rhs) NN_NOEXCEPT
{
    return rhs.operator errno_t() != lhs;
}

}}} // nn::ngc::detail
