﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfp/nfp_Types.h>

namespace nn { namespace nfp { namespace server {

class Date
{
public:
    Date() NN_NOEXCEPT;
    Date(int year, int month, int day) NN_NOEXCEPT;
    explicit Date(nn::Bit16 tagDate) NN_NOEXCEPT;
    Date(nn::Bit16 tagDate, bool withValidate) NN_NOEXCEPT;
    explicit Date(const nn::nfp::Date& nfpDate) NN_NOEXCEPT;
    Date(const nn::nfp::Date& nfpDate, bool withValidate) NN_NOEXCEPT;
    virtual ~Date() NN_NOEXCEPT {};

    nn::Bit16 GetTagDate() NN_NOEXCEPT;
    nn::nfp::Date GetNfpDate() NN_NOEXCEPT;

    static Date GetNow() NN_NOEXCEPT;

private:
    void SetDefault() NN_NOEXCEPT;
    void Validate() NN_NOEXCEPT;

private:
    int m_Year;
    int m_Month;
    int m_Day;
};
}}}  // namespace nn::nfp::server
