﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/svc/svc_Result.h>
#include <nn/nfp/nfp_EventApi.h>
#include "client/nfp_CommonInterface.h"
#include "detail/nfp_Util.h"
#include <nn/nn_SdkText.h> // for NN_TEXT

namespace nn { namespace nfp {

namespace
{
const char* AbortMessageForResultMaxHandle = NN_TEXT("nn::nfp::AttachActivateEvent() と nn::nfp::AttachDeactivateEvent() で初期化したイベントは使用後は必ず破棄を行う必要があります。\nエラーの発生などでイベントの再登録を行う場合も、NFC デバイスのハンドルに登録していたイベントを破棄してください。\nイベントの破棄は nn::os::DestroySystemEvent() を呼び出します。\n");
}

nn::Result AttachActivateEvent(nn::os::SystemEventType* pEvent, const DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    nn::sf::NativeHandle handle;
    nn::Result result = NN_NFP_CLIENT_GET_COMMON_INTERFACE(GetActivateEventHandle, (&handle, reinterpret_cast<const nn::nfc::DeviceHandle&>(deviceHandle)));
    NN_UNUSED(AbortMessageForResultMaxHandle);
    NN_ABORT_UNLESS(!nn::svc::ResultMaxHandle::Includes(result), AbortMessageForResultMaxHandle);
    NN_NFP_DETAIL_RESULT_DO(result);
    nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                              handle.GetOsHandle(),
                                              handle.IsManaged(),
                                              os::EventClearMode_AutoClear);
    handle.Detach();
    NN_RESULT_SUCCESS;
}

nn::Result AttachDeactivateEvent(nn::os::SystemEventType* pEvent, const DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    nn::sf::NativeHandle handle;
    nn::Result result = NN_NFP_CLIENT_GET_COMMON_INTERFACE(GetDeactivateEventHandle, (&handle, reinterpret_cast<const nn::nfc::DeviceHandle&>(deviceHandle)));
    NN_UNUSED(AbortMessageForResultMaxHandle);
    NN_ABORT_UNLESS(!nn::svc::ResultMaxHandle::Includes(result), AbortMessageForResultMaxHandle);
    NN_NFP_DETAIL_RESULT_DO(result);
    nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                              handle.GetOsHandle(),
                                              handle.IsManaged(),
                                              os::EventClearMode_AutoClear);
    handle.Detach();
    NN_RESULT_SUCCESS;
}

void AttachAvailabilityChangeEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    nn::sf::NativeHandle handle;
    nn::Result result = NN_NFP_CLIENT_GET_COMMON_INTERFACE(GetAvailabilityChangeEventHandle, (&handle));
    const char* abortMessage = NN_TEXT("nn::nfp::AttachAvailabilityChangeEvent() で初期化したイベントは使用後は必ず破棄を行う必要があります。\nエラーの発生などでイベントの再登録を行う場合も、登録していたイベントを破棄してください。\nイベントの破棄は nn::os::DestroySystemEvent() を呼び出します。\n");
    NN_UNUSED(abortMessage);
    NN_ABORT_UNLESS(!nn::svc::ResultMaxHandle::Includes(result), abortMessage);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                              handle.GetOsHandle(),
                                              handle.IsManaged(),
                                              os::EventClearMode_AutoClear);
    handle.Detach();
}
}}
