﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "nfc_SystemManager.h"
#include <nn/nfc/server/nfc_CommonImpl.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace nfc { namespace server {

SystemManager::SystemManager() NN_NOEXCEPT
{
}

SystemManager::~SystemManager() NN_NOEXCEPT
{
}

nn::Result SystemManager::CreateSystemInterface(
    nn::sf::Out<nn::sf::SharedPointer<nn::nfc::detail::ISystem>> pOutSystemInterface) NN_NOEXCEPT
{
    *pOutSystemInterface = nn::sf::DefaultObjectFactory::CreateSharedEmplaced<
        nn::nfc::detail::ISystem, nn::nfc::server::CommonImpl>();
    NN_RESULT_SUCCESS;
}

}}} // end of namespace nn::nfc::server
