﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os/os_MessageQueue.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace nfc { namespace server { namespace core {

    class SimpleMessageQueue
    {
        NN_DISALLOW_COPY(SimpleMessageQueue);
        NN_DISALLOW_MOVE(SimpleMessageQueue);

    public:
        explicit SimpleMessageQueue(size_t queueCapacity) NN_NOEXCEPT;
        ~SimpleMessageQueue() NN_NOEXCEPT;

        void Send(nn::Bit8 data) NN_NOEXCEPT;
        void Receive(nn::Bit8* pOutData) NN_NOEXCEPT;
        bool TimedReceive(nn::Bit8* pOutData, nn::TimeSpan timeout) NN_NOEXCEPT;
        void Peek(nn::Bit8* pOutData) NN_NOEXCEPT;
        void Clear() NN_NOEXCEPT;
        nn::os::MessageQueueType* GetBase() NN_NOEXCEPT;

    private:
        void Empty(uintptr_t data);

    private:
        std::unique_ptr<nn::os::MessageQueue> m_Queue;
        size_t m_QueueCapacity;
        std::unique_ptr<uintptr_t []> m_QueueBuffer;
        std::unique_ptr<bool []> m_IsEmpty;
        std::unique_ptr<nn::Bit8 []> m_Data;
        mutable nn::os::MutexType m_Mutex;
    };

}}}}  // namespace nn::nfc::server::core
