﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/fs.h>
#include <nn/nfc/server/core/nfc_Result.h>

namespace nn { namespace nfc { namespace server { namespace core {

class FileStream
{
public:
    FileStream() NN_NOEXCEPT;
    virtual ~FileStream() NN_NOEXCEPT;
    nn::Result Initialize(const char* path, int mode) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    nn::Result SetPosition(int64_t position) NN_NOEXCEPT;
    nn::Result Read(size_t* pOutSize, void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT;
    nn::Result Write(const void* pData, size_t dataSize, bool flush) NN_NOEXCEPT;
    nn::Result GetSize(int64_t* pOutSize) NN_NOEXCEPT;
    nn::Result Flush() NN_NOEXCEPT;

private:
    bool m_IsInitialized;
    nn::fs::FileHandle m_FileHandle;
    int64_t m_Pos;
};

}}}}  // namespace nn::nfc::server::core
