﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/nfc_MifareTagApi.h>
#include <nn/nfc/client/nfc_CommonInterface.h>
#include "detail/nfc_Util.h"

namespace nn { namespace nfc {

namespace
{
}

nn::Result ReadMifare(nn::nfc::MifareReadBlockData* pOutBlockData, const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::MifareReadBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutBlockData);
    NN_SDK_REQUIRES_NOT_NULL(pBlockParameter);
    NN_SDK_REQUIRES(0 < blockCount);
    nn::Bit8 format = pBlockParameter[0].key.valueFormat;
    NN_UNUSED(format);
    for(size_t i = 1; i < blockCount; ++i)
    {
        NN_SDK_REQUIRES_EQUAL(format, pBlockParameter[i].key.valueFormat);
    }

    nn::sf::OutArray<nn::nfc::MifareReadBlockData> data(pOutBlockData, blockCount);
    nn::sf::InArray<nn::nfc::MifareReadBlockParameter> parameter(pBlockParameter, blockCount);

    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(ReadMifare, (data, deviceHandle, parameter)));
}

nn::Result WriteMifare(const nn::nfc::DeviceHandle& deviceHandle, const nn::nfc::MifareWriteBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBlockParameter);
    NN_SDK_REQUIRES(0 < blockCount);
    nn::Bit8 format = pBlockParameter[0].key.valueFormat;
    NN_UNUSED(format);
    for(size_t i = 1; i < blockCount; ++i)
    {
        NN_SDK_REQUIRES_EQUAL(format, pBlockParameter[i].key.valueFormat);
    }

    nn::sf::InArray<nn::nfc::MifareWriteBlockParameter> parameter(pBlockParameter, blockCount);
    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(WriteMifare, (deviceHandle, parameter)));
}

}}
