﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/news/detail/service/news_ServiceCreator.generic.h>
#include <nn/news/detail/service/news_NewsService.generic.h>
#include <nn/news/detail/service/news_NewlyArrivedEventHolder.generic.h>
#include <nn/news/detail/service/news_NewsDataService.generic.h>
#include <nn/news/detail/service/news_NewsDatabaseService.generic.h>
#include <nn/news/detail/service/news_OverwriteEventHolder.generic.h>
#include <nn/news/detail/service/news_ServiceMemoryManager.h>
#include <nn/news/news_ResultPrivate.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace news { namespace detail { namespace service {

ServiceCreatorForGeneric::ServiceCreatorForGeneric() NN_NOEXCEPT
{
}

ServiceCreatorForGeneric::~ServiceCreatorForGeneric() NN_NOEXCEPT
{
}

nn::Result ServiceCreatorForGeneric::CreateNewsService(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewsService>> outService) NN_NOEXCEPT
{
    auto& allocator = ServiceMemoryManager::GetInstance().GetNewsServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::INewsService, NewsServiceForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateNewlyArrivedEventHolder(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewlyArrivedEventHolder>> outHolder) NN_NOEXCEPT
{
    auto& allocator = ServiceMemoryManager::GetInstance().GetNewlyArrivedEventHolderAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::INewlyArrivedEventHolder, NewlyArrivedEventHolderForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outHolder.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateOverwriteEventHolder(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::IOverwriteEventHolder>> outHolder) NN_NOEXCEPT
{
    auto& allocator = ServiceMemoryManager::GetInstance().GetOverwriteEventHolderAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IOverwriteEventHolder, OverwriteEventHolderForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outHolder.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateNewsDataService(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewsDataService>> outService) NN_NOEXCEPT
{
    auto& allocator = ServiceMemoryManager::GetInstance().GetNewsDataServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::INewsDataService, NewsDataServiceForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateNewsDatabaseService(nn::sf::Out<nn::sf::SharedPointer<nn::news::detail::ipc::INewsDatabaseService>> outService) NN_NOEXCEPT
{
    auto& allocator = ServiceMemoryManager::GetInstance().GetNewsDatabaseServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::INewsDatabaseService, NewsDatabaseServiceForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

}}}}
