﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/mmnv/sfdl/mmnv.sfdl.h>


namespace nn   {
namespace mmnv {
namespace server {

class RequestImpl
{
public:
    nn::Result Initialize(Module moduleId, Priority priority, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
    nn::Result Finalize(Module moduleId) NN_NOEXCEPT;
    nn::Result SetAndWait(Module moduleId, uint32_t min, uint32_t max) NN_NOEXCEPT;
    nn::Result Get(nn::sf::Out<uint32_t> setting, Module moduleId) NN_NOEXCEPT;

    nn::Result InitializeById(nn::sf::Out<std::int32_t> requestId, nn::mmnv::Module moduleId, nn::mmnv::Priority priority,
                          nn::os::EventClearMode eventClearMode) NN_NOEXCEPT;
    nn::Result FinalizeById(std::int32_t requestId) NN_NOEXCEPT;
    nn::Result SetAndWaitById(std::int32_t requestId, std::uint32_t min, std::uint32_t max) NN_NOEXCEPT;
    nn::Result GetById(nn::sf::Out<std::uint32_t> setting, std::int32_t requestId) NN_NOEXCEPT;

    RequestImpl();
    ~RequestImpl();
};

}}}

