﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.mii.detail
{

    public interface IImageDatabaseService : IServiceObject
    {
        // 初期化系 0～
        [MethodId(0)]
        Result Initialize(Out<int8_t> outDatabaseResult, bool enableFormat);

        // 機能提供 10～

        [MethodId(10)]
        Result Reload();

        [MethodId(11)]
        Result GetCount(Out<int32_t> outValue);

        [MethodId(12)]
        Result IsEmpty(Out<bool> outValue);

        [MethodId(13)]
        Result IsFull(Out<bool> outValue);

        [MethodId(14)]
        Result GetAttribute(Out<nn.mii.detail.ImageAttributeImpl> outAttribute, int32_t index);

        [MethodId(15)]
        Result LoadImage([BufferTransferMode(BufferTransferMode.MapAlias)] OutBuffer outBuffer, nn.util.Uuid uuid);

        [MethodId(16)]
        Result AddOrUpdateImage(
            Out<int32_t> outIndex,
            int8_t expression,
            int8_t pose,
            int8_t fontRegion,
            nn.mii.Nickname nickname,
            nn.mii.CreateId createId,
            nn.util.Uuid UsedUuid,
            [BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.util.Uuid> validUuidArray,
            [BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer srcBuffer
            );

        [MethodId(17)]
        Result DeleteImages([BufferTransferMode(BufferTransferMode.MapAlias)] InArray<nn.util.Uuid> uuids);

        // デバッグ用 100～

        [MethodId(100)]
        Result DeleteFile();

        [MethodId(101)]
        Result DestroyFile();

        [MethodId(102)]
        Result ImportFile([BufferTransferMode(BufferTransferMode.MapAlias)] InBuffer inBuffer);

        [MethodId(103)]
        Result ExportFile([BufferTransferMode(BufferTransferMode.MapAlias)] Out<int64_t> outSize, OutBuffer outBuffer);

        [MethodId(104)]
        Result ForceInitialize(Out<int8_t> outDatabaseResult, bool enableFormat);

    }
}
