﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include "lm_LogServiceImpl.h"

namespace nn { namespace lm { namespace impl {

class LogGetter
{
public:
    Result StartLogging() NN_NOEXCEPT;
    Result StopLogging() NN_NOEXCEPT;
    Result GetLog(sf::OutBuffer message, sf::Out<int64_t> pOutSize, sf::Out<uint32_t> pOutDropCount) NN_NOEXCEPT;
};

}}} // nn::lm::impl
